package com.ejie.aa17a.dao.impl.comun;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.comun.Aa17aComboDao;
import com.ejie.aa17a.model.comun.Aa17aCombo;

/**
 * Aa17aAvisoDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aComboDaoImpl implements Aa17aComboDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Aa17aCombo> rwComboMap = new RowMapper<Aa17aCombo>() {
		public Aa17aCombo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Locale locale = LocaleContextHolder.getLocale();

			if (com.ejie.x38.util.Constants.EUSKARA
					.equals(locale.getLanguage())) {
				return new Aa17aCombo(resultSet.getString("REG_ID"),
						resultSet.getString("DESC_EU"));
			}
			else {
				return new Aa17aCombo(resultSet.getString("REG_ID"),
						resultSet.getString("DESC_ES"));
			}

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Obtiene la lista de estaciones para cargar un combo.
	 * 
	 * @return List<Aa17aCombo>
	 */
	@Transactional(readOnly = true)
	public List<Aa17aCombo> findComboEstaciones() {
		StringBuilder query = new StringBuilder();
		query.append(" SELECT T01_ESTACION_ID REG_ID, T01_NOMBRE DESC_ES, T01_NOMBRE DESC_EU FROM AA1701S00 ");
		query.append(" WHERE T01_FECHA_BAJA IS NULL "); //que no esté dada de baja
		query.append(" ORDER BY T01_NOMBRE ");
		List<Object> params = new ArrayList<Object>();

		return (List<Aa17aCombo>) this.jdbcTemplate.query(query.toString(),
				this.rwComboMap, params.toArray());
	}

	/**
	 * Obtiene la lista de contaminantes de una estacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return List<Aa17aCombo>
	 */
	@Transactional(readOnly = true)
	public List<Aa17aCombo> findComboContaminantesEstacion(Long idEstacion) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT AA1703S00.T02_CONTAMINANTE_ID REG_ID, ");
		query.append(" AA1702S00.T02_NOMBRE AS DESC_ES, ");
		query.append(" AA1702S00.T02_NOMBRE AS DESC_EU ");
		query.append(" FROM AA1703S00 ");
		query.append(" INNER JOIN AA1702S00 ON AA1702S00.T02_CONTAMINANTE_ID = AA1703S00.T02_CONTAMINANTE_ID ");
		query.append(" WHERE AA1703S00.T01_ESTACION_ID = ? ");

		List<Object> params = new ArrayList<Object>();

		params.add(idEstacion);

		return (List<Aa17aCombo>) this.jdbcTemplate.query(query.toString(),
				this.rwComboMap, params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
